# Anaconda Enterprise Session

Integration between Anaconda Enterprise 5 and [code-server](https://github.com/cdr/code-server), also referred to as
VS Code, is provided with this extension.

## Session startup

![](https://github.com/Anaconda-Platform/vscode-ae5-session/raw/HEAD/images/prepare.gif)

When an editor session launches the Conda environment defined in the `anaconda-project.yml` is prepared. It may take
several minutes to download and install the required packages.

If an error is encountered you can click `Show errors` to view the full error message.

![](https://github.com/Anaconda-Platform/vscode-ae5-session/raw/HEAD/images/env_error.gif)

## Python interpreter

When you open a Python `.py` or Jupyter Notebook `.ipynb` file the [Microsoft Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python) will activate. The
extension will choose the correct Python interpreter based on the environment defined in your `anaconda-project.yml` file.

![](https://github.com/Anaconda-Platform/vscode-ae5-session/raw/HEAD/images/ms-python.png)

Notice that the `anaconda50_py36` Conda environment has been activated in the above screenshot.

### Environment is not yet ready

If you open a Python or notebook file before the environment has finished preparing it will warn you to select an
interpreter before you can execute the code.

![](https://github.com/Anaconda-Platform/vscode-ae5-session/raw/HEAD/images/wait.png)

Once the environment has finished the message will inform you that you **must reload VSCode** in order to use the
Conda environment defined in the `anaconda-project.yml` file.

![](https://github.com/Anaconda-Platform/vscode-ae5-session/raw/HEAD/images/reload.png)

Once the editor window has reloaded the Python interpreter will be set. This only needs to be done once for the lifetime
of the editor session.

![](https://github.com/Anaconda-Platform/vscode-ae5-session/raw/HEAD/images/ready.png)

## Deployment Preview

![](https://github.com/Anaconda-Platform/vscode-ae5-session/raw/HEAD/images/preview.gif)


## JSON setting errors

![](https://github.com/Anaconda-Platform/vscode-ae5-session/raw/HEAD/images/json_error.png)
