import { LoggingSeverity, _InternalMessageId } from "../JavaScriptSDK.Enums/LoggingEnums";
import { IAppInsightsCore } from "../JavaScriptSDK.Interfaces/IAppInsightsCore";
import { IConfiguration } from "../JavaScriptSDK.Interfaces/IConfiguration";
import { IDiagnosticLogger } from "../JavaScriptSDK.Interfaces/IDiagnosticLogger";
export declare class _InternalLogMessage {
    static dataType: string;
    message: string;
    messageId: _InternalMessageId;
    constructor(msgId: _InternalMessageId, msg: string, isUserAct?: boolean, properties?: Object);
}
export declare function safeGetLogger(core: IAppInsightsCore, config?: IConfiguration): IDiagnosticLogger;
export declare class DiagnosticLogger implements IDiagnosticLogger {
    identifier: string;
    /**
     * The internal logging queue
     */
    queue: _InternalLogMessage[];
    constructor(config?: IConfiguration);
    /**
     * When this is true the SDK will throw exceptions to aid in debugging.
     */
    enableDebugExceptions(): boolean;
    /**
     * 0: OFF (default)
     * 1: CRITICAL
     * 2: >= WARNING
     */
    consoleLoggingLevel(): number;
    /**
     * 0: OFF
     * 1: CRITICAL (default)
     * 2: >= WARNING
     */
    telemetryLoggingLevel(): number;
    /**
     * The maximum number of internal messages allowed to be sent per page view
     */
    maxInternalMessageLimit(): number;
    /**
     * This method will throw exceptions in debug mode or attempt to log the error as a console warning.
     * @param severity {LoggingSeverity} - The severity of the log message
     * @param message {_InternalLogMessage} - The log message.
     */
    throwInternal(severity: LoggingSeverity, msgId: _InternalMessageId, msg: string, properties?: Object, isUserAct?: boolean): void;
    /**
     * This will write a warning to the console if possible
     * @param message {string} - The warning message
     */
    warnToConsole(message: string): void;
    /**
     * This will write an error to the console if possible
     * @param message {string} - The warning message
     */
    errorToConsole(message: string): void;
    /**
     * Resets the internal message count
     */
    resetInternalMessageCount(): void;
    /**
     * Logs a message to the internal queue.
     * @param severity {LoggingSeverity} - The severity of the log message
     * @param message {_InternalLogMessage} - The message to log.
     */
    logInternalMessage(severity: LoggingSeverity, message: _InternalLogMessage): void;
}
/**
 * This is a helper method which will call throwInternal on the passed logger, will throw exceptions in
 * debug mode or attempt to log the error as a console warning. This helper is provided mostly to better
 * support minification as logger.throwInternal() will not compress the publish "throwInternal" used throughout
 * the code.
 * @param logger - The Diagnostic Logger instance to use.
 * @param severity {LoggingSeverity} - The severity of the log message
 * @param message {_InternalLogMessage} - The log message.
 */
export declare function _throwInternal(logger: IDiagnosticLogger, severity: LoggingSeverity, msgId: _InternalMessageId, msg: string, properties?: Object, isUserAct?: boolean): void;
/**
 * This is a helper method which will call warnToConsole on the passed logger with the provided message.
 * @param logger - The Diagnostic Logger instance to use.
 * @param message {_InternalLogMessage} - The log message.
 */
export declare function _warnToConsole(logger: IDiagnosticLogger, message: string): void;
/**
 * Logs a message to the internal queue.
 * @param logger - The Diagnostic Logger instance to use.
 * @param severity {LoggingSeverity} - The severity of the log message
 * @param message {_InternalLogMessage} - The message to log.
 */
export declare function _logInternalMessage(logger: IDiagnosticLogger, severity: LoggingSeverity, message: _InternalLogMessage): void;
