import { IFeatureProvider, FeatureData } from './IFeatureProvider';
import { IExperimentationTelemetry } from 'src/contracts/IExperimentationTelemetry';
/**
 * Abstract class for Feature Provider Implementation.
 */
export declare abstract class BaseFeatureProvider implements IFeatureProvider {
    protected telemetry: IExperimentationTelemetry;
    private fetchPromise?;
    private isFetching;
    /**
     * @param telemetry The telemetry implementation.
     */
    constructor(telemetry: IExperimentationTelemetry);
    /**
     * Method that wraps the fetch method in order to re-use the fetch promise if needed.
     * @param headers The headers to be used on the fetch method.
     */
    getFeatures(): Promise<FeatureData>;
    /**
     * Fetch method that retrieves asynchronously the required feature data.
     */
    protected abstract fetch(): Promise<FeatureData>;
}
